(ns shared.models.resource.index
  (:require [shared.protocols.specced :refer [Specced]]
            [shared.protocols.convertible :refer [Convertible]]
            [shared.protocols.loggable :as log]
            [shared.models.query.index :as query]))

(defrecord Resource []
  Convertible
  (-to-query [{:keys [resource-url]}] (query/create {:resource-url resource-url}))
  Specced
  (-resolve [this] :resources))

(defmulti create #(if (:resourceUrl %1) :graphql :offcourse))

(defn convert-video-content [{:keys [videoId videoProvider]}]
  {:video-id videoId
   :video-provider videoProvider})

(defmethod create :graphql [{:keys [content resourceType tags resourceUrl description] :as raw-resource}]
  (-> {:resource-type resourceType
       :resource-url resourceUrl
       :content (or (:html content) (convert-video-content content))
       :tags tags
       :description description}
      map->Resource
      (with-meta {:spec :offcourse/resource})))

(defmethod create :offcourse [{:keys [content resource-type] :as raw-resource}]
  (-> raw-resource
      map->Resource
      (with-meta {:spec :offcourse/resource})))
