(ns shared.models.course.index
  (:require [shared.models.checkpoint.index :as checkpoint]
            [shared.models.course.convertible :as cv-impl]
            [shared.models.course.actionable :as ac-impl]
            [offcourse.specs.course]
            [shared.models.course.get :as get-impl]
            [shared.models.course.missing-data :as md-impl]
            [shared.protocols.actionable :as ac :refer [Actionable]]
            [shared.protocols.convertible :refer [Convertible]]
            [shared.protocols.queryable :refer [Queryable]]
            [shared.protocols.specced :refer [Specced]]
            [shared.protocols.loggable :as log]
            [clojure.set :as set]
            [cljs.spec.alpha :as spec]
            [cuerdas.core :as str]))

(defrecord Course []
  Queryable
  (-get [this query] (get-impl/get this query))
  (-missing-data [this query] (md-impl/missing-data this query))
  Actionable
  (-perform [this action] (ac-impl/perform this action))
  Convertible
  (-to-bookmarks [this] (cv-impl/to-bookmarks this))
  (-to-query [this] (cv-impl/to-query this))
  (-to-status-query [this checkpoint] (cv-impl/to-status-query this checkpoint)))

(defn initialize [{:keys [goal curator description checkpoints]}]
  (let [course-id (str (random-uuid))]
    {:base-id course-id
     :course-id course-id
     :repository "offcourse"
     :description description
     :revision 0
     :parent-id nil
     :curator (str/human curator)
     :goal (str/human goal)
     :timestamp (.now js/Date)
     :checkpoints (map checkpoint/initialize checkpoints)}))

(defn create [{:keys [base-id course-id goal curator repository description
                      checkpoints timestamp revision parent-id]}]
  (-> {:base-id base-id
       :course-id course-id
       :repository repository
       :description description
       :revision revision
       :parent-id parent-id
       :curator (str/human curator)
       :goal (str/human goal)
       :timestamp timestamp
       :checkpoints (map checkpoint/create checkpoints)}
      map->Course
      (with-meta {:spec :course/valid})))

