(ns backend-adapters.http.fetch
  (:require [shared.protocols.loggable :as log]
            [cljs.core.async :as async]
            [shared.protocols.convertible :as cv])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn handle-response [c url error res binary?]
  (if error
    (async/put! c [:error [url error]])
    (async/put! c [:found [url (if binary? res (cv/to-clj res))]]))
  (async/close! c))

(defn -fetch [adapter url binary?]
  (let [options {:uri url
                 :encoding (if binary? nil "utf-8")}
        c (async/chan)]
    (adapter (clj->js options) #(handle-response c url %1 %3 binary?))
    c))

(defn fetch [adapter {:keys [urls binary?]}]
  (go
    (let [query-chans (async/merge (map #(-fetch adapter % binary?) urls))
          res         (async/<! (async/into [] query-chans))
          sorted      (reduce
                       (fn [acc [res-type [url data]]]
                         (assoc-in acc [res-type url] data)) {} res)]
      sorted)))
