(ns backend-shared.service.index
  (:require [backend-shared.aws-event.index :as aws-event]
            [backend-shared.specs.index]
            [backend-shared.protocol-extensions.index]
            [backend-adapters.index :as adapters]
            [backend-shared.service.log :as log]
            [backend-shared.service.fetch :as fetch]
            [backend-shared.service.perform :as perform]
            [backend-shared.service.check :as check]
            [backend-shared.service.respond :as respond]
            [shared.protocols.convertible :as cv]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.eventful :refer [Eventful]]
            [shared.protocols.queryable :refer [Queryable]]))

(defrecord Service []
  Actionable
  (-perform [service action] (perform/perform service action))
  (-check   [service action data] (check/check service action data))
  Eventful
  (-respond [service payload] (respond/respond service payload))
  Queryable
  (-fetch [service query] (fetch/fetch service query)))

(defn create [adapters-config event context callback]
  (log/incoming event context)
  (let [adapters (adapters/create adapters-config callback)
        config {:stage (.. js/process -env -STAGE)
                :callback callback
                :context (cv/to-clj context)
                :event   (aws-event/create event)}]
  (map->Service (merge config adapters))))

(def fetch fetch/fetch)
(def perform perform/perform)
(def check check/check)
