(ns backend-adapters.stepfunctions.perform
  (:require [backend-adapters.stepfunctions.converters.action :refer [action->sf]]
            [backend-adapters.stepfunctions.impl.execute :refer [execute]]
            [cljs.core.async :refer [<!]]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [_ action] (sp/resolve action)))

(defmethod perform :default [{:keys [instance machine-names]} action]
  (go
    (let [{:keys [stateMachineArn] :as sf-action} (action->sf action machine-names)
          [res-type payload :as res] (<! (execute instance sf-action))]
      (if (= res-type :succeeded)
        (event/create [:triggered {:execution-arn (:executionArn payload)
                                   :state-machine-arn stateMachineArn
                                   :start-date (str (:startDate payload))}])
        res))))
