(ns backend-adapters.index
  (:require [backend-adapters.auth0.index :as auth0]
            [backend-adapters.dynamodb.index :as dynamodb]
            [backend-adapters.es.index :as es]
            [backend-adapters.http.index :as http]
            [backend-adapters.iam.index :as iam]
            [backend-adapters.s3.index :as s3]
            [backend-adapters.algolia.index :as algolia]
            [backend-adapters.stepfunctions.index :as stepfunctions]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]))

(def constructors {:db            #(dynamodb/create %)
                   :state-machine #(stepfunctions/create %)
                   :http          #(http/create %)
                   :auth          #(auth0/create %)
                   :iam           #(iam/create %)
                   :index         #(es/create %)
                   :bucket        #(s3/create %)})

(defn check [[key val]] (if-not val key (when (map? val) (keep check val))))

(defn create [adapters]
  (reduce (fn [acc [adapter-name config]]
            (let [errors (flatten (keep check config))]
              (if-not (empty? errors)
                (assoc acc adapter-name ((adapter-name constructors) {:error (error/create :missing-env-vars
                                                                                           {:adapter adapter-name
                                                                                            :env-vars errors})}))
                (assoc acc adapter-name ((adapter-name constructors) config)))))
          {} adapters))
