(ns backend-adapters.es.converters.query
  (:require [shared.protocols.specced :as sp]
            [cuerdas.core :as str]
            [shared.protocols.loggable :as log]))

(defmulti query->es sp/resolve)

(defn course-template [query]
  {:index "offcourse"
   :type "courses"
   :body {:query query}})

(defmethod query->es :course [{:keys [course-slug curator]}]
  (course-template {:bool {:must [{:match_phrase {:goal (str/human course-slug)}}
                                  {:match_phrase {:curator curator}}]}}))

(defmethod query->es :collection [{:keys [collection-name collection-type]}]
  (let [collection-type (if (= collection-type "tags") "checkpoints.tags" collection-type)
        collection-query {:bool {:should [{:match {collection-type collection-name}}]}}
        query (if (= collection-name "all") {} collection-query)]
    (course-template (if (= collection-name "all") {:match_all {}} collection-query))))
