(ns backend-adapters.algolia.index
  (:require [shared.protocols.loggable :as log]
            [shared.models.event.index :as event]
            [backend-adapters.algolia.perform :refer [perform]]
            [backend-adapters.algolia.fetch :refer [fetch]]
            [backend-adapters.algolia.specs :refer [specs]]
            [algoliasearch :as algolia]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.queryable :refer [Queryable]])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn create [{:keys [application-id admin-key error] :as config}]
  (let [instance      (algolia application-id admin-key)
        coursesIndex (.initIndex instance "courses")]
    (.setSettings coursesIndex
                  (clj->js {:attributesForFaceting ["curator"]
                            :searchableAttributes ["curator" "course-id" "revision"
                                                   "goal" "checkpoints.tags"]}))
    (specify! {:instance instance
               :error error
               :specs specs
               :indices {:courses coursesIndex}}
      Queryable
      (-fetch [this query] (fetch this query))
      Actionable
      (-perform [{:keys [error] :as this} action]
        (if error
          (go (event/create [:failed error]))
          (perform this action))))))
