(ns backend-adapters.algolia.impl.save
  (:require [cljs.core.async :refer [chan close! put!]]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.convertible :as cv]))

(defn handle-response [c error res]
  (if error
    (put! c (event/create [:failed (error/create :algoliasearch-error error)]))
    (put! c (event/create [:saved (cv/to-clj res)])))
  (close! c))

(defn save-many [index query]
  (let [c (chan)]
    (.addObjects index (clj->js query) #(handle-response c %1 %2))
    c))
