(ns backend-adapters.algolia.impl.remove
  (:refer-clojure :exclude [remove])
  (:require [cljs.core.async :refer [<! put! merge into chan close!]]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.convertible :as cv])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn handle-response [c error res]
  (if error
    (put! c (event/create [:failed (error/create :algoliasearch-error error)]))
    (put! c (event/create [:removed (cv/to-clj res)])))
  (close! c))

(defn remove [index query]
  (let [c (chan)]
    (.deleteByQuery index (clj->js query) #(handle-response c %1 %2))
    c))

(defn remove-many [index queries]
  (go
    (let [query-chans (merge (map #(remove index %) queries))
          res         (<! (into [] query-chans))
          errors      (filter (fn [[result data]] (= :failed result)) res)]
      (if (empty? errors)
        (event/create [:removed (map second res)])
        (event/create [:failed (error/create :algolia-error (map second errors))])))))
