(ns backend-adapters.algolia.converters.query
  (:require [shared.protocols.specced :as sp]
            [cuerdas.core :as str]))

(defmulti query->algolia sp/resolve)

(defmethod query->algolia :course [{:keys [course-slug curator]}]
  {:query (str/human course-slug)
   :queryType "prefixNone"
   :typoTolerance false
   :restrictSearchableAttributes ["goal"]
   :filters (str "curator:" curator)})

(defmethod query->algolia :collection [{:keys [collection-name collection-type]}]
  (if (= collection-type "flags")
    {:query ""}
    {:query collection-name
     :queryType "prefixNone"
     :typoTolerance false
     :restrictSearchableAttributes
     [(if (= collection-type "tags") "checkpoints.tags" collection-type)]}))
