(ns backend-shared.specs.index
  (:require [cljs.spec.alpha :as spec]
            [offcourse.specs.core]
            [backend-shared.specs.aws.index]
            [backend-shared.specs.course]
            [backend-shared.specs.bookmark]
            [backend-shared.specs.resource]
            [backend-shared.specs.github]
            [backend-shared.specs.aws.index]
            [backend-shared.specs.mercury]
            [backend-shared.specs.embedly]))

(spec/def ::compressed-data string?)
(spec/def :offcourse/compressed (spec/keys :req-un [::compressed-data]))

(spec/def :user/data (spec/keys :req-un [:offcourse/profile
                                         :offcourse/portrait
                                         :offcourse/identities]))

(spec/def ::missing #{:not-found "not-found"})
(spec/def :missing/resource ::missing)
(spec/def :missing/raw-resource ::missing)

(spec/def :query/missing-resource
  (spec/merge :resource/query (spec/keys :req-un [:missing/resource])))

(spec/def :query/missing-raw-resource
  (spec/merge :query/missing-resource (spec/keys :req-un [:missing/raw-resource])))

(spec/def :bookmark/missing-resource
  (spec/merge :bookmark/valid
              (spec/keys :req-un [:offcourse/course])
              :query/missing-resource))
