(ns backend-adapters.s3.fetch
  (:require [backend-adapters.s3.impl.get :refer [get]]
            [backend-adapters.s3.converters.query :refer [query->s3]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti fetch (fn [_ query] (sp/resolve query)))

(defmethod fetch :bucket-item [{:keys [instance bucket-names] :as adapter} query]
  (set! (.-region (.-credentials (.-config instance))) "us-east-1")
  (get instance (query->s3 query bucket-names)))

(defmethod fetch :default [{:keys [instance credentials bucket-names]} query]
  (get instance (query->s3 query bucket-names)))

(defmethod fetch :invalid-query [_ query]
  (go (event/create [:failed (error/create :s3-unsupported-query query)])))
