(ns backend-adapters.es.specs
  (:require [cljs.spec.alpha :as spec]))

(defmulti action-spec (fn [[action-type _ :as action]] action-type))

(defmethod action-spec :remove [_]
  (spec/tuple :action/types (spec/or :course-queries (spec/coll-of :course/query))))

(defmethod action-spec :save [_]
  (spec/tuple :action/types (spec/or :courses (spec/coll-of :course/valid))))

(spec/def :query/query (spec/or :collection :collection/query
                                :resource   :resource/query
                                :resources  (spec/coll-of :resource/query)
                                :course     :course/query))

(def specs {:query :query/query
            :action (spec/multi-spec action-spec :action-type)})
