(ns backend-adapters.algolia.perform
  (:require [cljs.core.async :refer [<! put! merge into chan]]
            [backend-adapters.algolia.converters.action :refer [action->algolia]]
            [backend-adapters.algolia.impl.save :refer [save-many]]
            [backend-adapters.algolia.impl.remove :refer [remove-many]]
            [shared.models.error.index :as error]
            [shared.protocols.loggable :as log]
            [shared.models.event.index :as event]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [service action] (sp/resolve action)))

(defmethod perform [:save :courses] [{:keys [indices] :as this} [_ payload :as action]]
  (go
    (let [index (:courses indices)
          [status :as res]   (<! (save-many index (action->algolia action)))]
      (if (= status :saved)
        (event/create [:saved payload])
        res))))

(defmethod perform [:remove :course-queries] [{:keys [indices] :as this} [_ payload :as action]]
  (go
    (let [index       (:courses indices)
          actions     (action->algolia action)
          [status :as res]   (<! (remove-many index (action->algolia action)))]
      (if (= status :removed)
        (event/create [:removed payload])
        res))))
