(ns backend-adapters.algolia.fetch
  (:require [cljs.core.async :refer [<!]]
            [backend-adapters.algolia.impl.retrieve :refer [search]]
            [backend-adapters.algolia.converters.query :refer [query->algolia]]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp]
            [cljs.spec.alpha :as spec]
            [cuerdas.core :as str])
  (:require-macros [cljs.core.async.macros :refer [go]]))


(defmulti fetch (fn [service query] (sp/resolve query)))

(defmethod fetch :course [{:keys [endpoint indices] :as this} query]
  (go
    (let [index (:courses indices)
          [res-type payload :as res] (<! (search index (query->algolia query)))]
      (if  (= res-type :found)
        (event/create [:found (first payload)])
        (event/create [:not-found query])))))

(defmethod fetch :collection [{:keys [endpoint indices] :as this} query]
  (go
    (let [index (:courses indices)
          [res-type :as res] (<! (search index (query->algolia query)))]
      (if  (= res-type :not-found)
        (event/create [:not-found query])
        res))))
