(ns backend-adapters.algolia.converters.action
  (:require [shared.protocols.specced :as sp]))

(defmulti action->algolia sp/resolve)

(defmethod action->algolia [:save :courses] [[_ payload]]
  (map #(assoc % :objectID (:course-id %1)) payload))

(defmethod action->algolia [:remove :course-queries] [[_ payload]]
  (map (fn [{:keys [course-id revision]}]
         {:query course-id
          :queryType "prefixNone"
          :typoTolerance false
          :restrictSearchableAttributes ["course-id" "revision"]
          :filters (str "revision = " 0)}) payload))
