(ns backend-adapters.s3.to-query
  (:require [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp]
            [backend-shared.crypto :as crypto]))

(defmulti to-query (fn [query bucket-names] (sp/resolve query)))

(defmethod to-query :resource [{:keys [resource-url]} bucket-names]
  {:Bucket (:resource bucket-names)
   :Key (str (crypto/hasher resource-url) ".json")})

(defmethod to-query :default [{:keys [bucket-name item-key]} bucket-names]
  {:Bucket bucket-name
   :Key item-key})
