(ns backend-adapters.s3.index
  (:require [backend-adapters.s3.fetch :refer [fetch]]
            [backend-adapters.s3.perform :refer [perform]]
            [backend-adapters.s3.specs :refer [specs]]
            [aws-sdk :refer [S3]]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.models.event.index :as event]
            [shared.protocols.queryable :refer [Queryable]])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn create [{:keys [bucket-names error] :as this}]
  (specify! {:instance (new S3)
             :error error
             :bucket-names bucket-names
             :specs specs}
    Queryable
    (-fetch
      ([this query] (fetch this query))
      ([this credentials query] (fetch this credentials query)))
    Actionable
    (-perform [{:keys [error] :as this} action]
      (if error
        (go (event/create [:failed error]))
        (perform this action)))))
