(ns backend-adapters.s3.impl.save
  (:require [cljs.core.async :refer [<! chan close! into merge put!]]
            [cljs.spec.alpha :as spec]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn- handle-response [channel error payload]
  (let [response (event/create (if error
                    [:failed (error/create :s3-error error)]
                    [:saved payload]))]
    (put! channel response)
    (close! channel)))

(defn- save-one [instance action]
  (let [c (chan)]
    (.putObject instance (clj->js action) #(handle-response c %1 %2))
   c))

(defn- save-many [instance action]
  (go
    (let [query-chans (merge (map #(save-one instance %) action))
          res         (<! (into [] query-chans))
          errors      (filter (fn [[result data]] (= :failed result)) res)]
      (if (empty? errors)
        (event/create [:saved (map second res)])
        (event/create [:failed (error/create :s3-error (map second errors))])))))

(defmulti save (fn [_ actions] (if (spec/valid? (spec/coll-of map?) actions) :many :one)))

(defmethod save :one [instance action]
  (save-one instance action))

(defmethod save :many [instance actions]
  (save-many instance actions))
