(ns backend-adapters.algolia.impl.retrieve
  (:require [cljs.core.async :refer [chan close! put!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]
            [shared.protocols.convertible :as cv]))

(defn extract-items [res]
  (->> res
       cv/to-clj
       :hits
       (map #(dissoc %1 :objectID :highlightResult))))

(defn handle-error [c error]
  (put! c (event/create [:failed (error/create :algoliasearch-error error)]))
  (close! c))

(defn handle-success [c res]
  (let [items (extract-items res)]
    (put! c (event/create (if (empty? items) [:not-found] [:found items])))
    (close! c)))

(defn handle-promise [f]
  (let [c (chan)]
    (.then f #(handle-success c %1) #(handle-error c %1))
    c))

(defn search [instance query]
  (handle-promise (.search instance (clj->js query))))
