(ns backend-adapters.es.impl.save
  (:require [cljs.core.async :refer [chan close! put!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.convertible :as cv]))

(defn handle-error [c error]
  (put! c (event/create [:failed (error/create :elasticsearch-error error)]))
  (close! c))

(defn handle-success [c res]
  (put! c (event/create [:saved (cv/to-clj res)]))
  (close! c))

(defn handle-promise [f]
  (let [c (chan)]
    (.then f #(handle-success c %1) #(handle-error c %1))
    c))

(defn put [instance query]
  (handle-promise (.index instance (clj->js query))))

(defn batch [instance query]
  (handle-promise (.bulk instance (clj->js query))))

(defn search [instance query]
  (handle-promise (.search instance (clj->js query))))
