(ns backend-adapters.es.fetch
  (:require [backend-adapters.es.converters.query :refer [query->es]]
            [backend-adapters.es.impl.retrieve :refer [search]]
            [cljs.core.async :refer [<!]]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti fetch (fn [service query] (sp/resolve query)))

(defmethod fetch :course [{:keys [endpoint instance] :as this} query]
  (go
    (let [[res-type payload :as res] (<! (search instance (query->es query)))]
      (if  (= res-type :found)
        (event/create [:found (first payload)])
        (event/create [:not-found query])))))

(defmethod fetch :collection [{:keys [endpoint instance] :as this} query]
  (go
    (let [[res-type :as res] (<! (search instance (query->es query)))]
      (if  (= res-type :not-found)
        (event/create [:not-found query])
        res))))
