(ns backend-shared.converters.zip
  (:require [cljs.nodejs :as node]
            [shared.protocols.convertible :as cv]))

(def zip-key :data)

(def Zip (node/require "node-zip"))

(defn ->compressed [payload]
  (-> (new Zip)
      (.file (name zip-key) (.stringify js/JSON (clj->js payload)))
      (.generate (clj->js {:base64 true :compression :DEFLATE}))))

(defn ->clj [payload]
  (-> (new Zip (:compressed-data payload) (clj->js {:base64 true :checkCRC32 true}))
      cv/to-clj
      (get-in [:files zip-key :_data])
      cv/to-clj))
