(ns backend-shared.converters.helpers
(:require [cljs.nodejs :as node]
          [shared.protocols.loggable :as log]
          [shared.protocols.convertible :as cv]
          [clojure.string :as str]))

(def URL (node/require "url"))
(def nlp (node/require "compromise"))

(def hostname->type
  {"www.youtube.com" :video})

(def hostname->provider
  {"www.youtube.com" :youtube})

(defn filter-tags [all-tags]
  (->> all-tags
       (filter #(< (count %) 20))
       frequencies
       (sort-by second)
       reverse
       (take 5)
       (map first)
       (into #{})))

(defn collect-tags [content]
  (if (< (count content) 200)
    #{}
    (-> content
        clj->js
        nlp
        .nouns
        (.out "array"))))

(defn find-checkpoint-index [checkpoints checkpoint-id]
  (->> checkpoints
       (map-indexed vector)
       (filter #(= (:checkpoint-id (second %)) checkpoint-id))
       first
       first))
