(ns backend-adapters.dynamodb.fetch
  (:refer-clojure :exclude [get])
  (:require [backend-adapters.dynamodb.converters.query :refer [query->ddb]]
            [backend-adapters.dynamodb.impl.get :refer [get]]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn fetch [{:keys [instance table-names] :as adapter} query]
  (get instance (query->ddb query table-names)))
