(ns backend-adapters.es.perform
  (:require [backend-adapters.es.converters.action :refer [action->es]]
            [backend-adapters.es.impl.save :refer [batch]]
            [cljs.core.async :refer [<!]]
            [shared.models.event.index :as event]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn failed? [[status _]] (= status :failed))

(defmulti perform (fn [service action] (sp/resolve action)))

(defmethod perform [:save :courses] [{:keys [endpoint instance] :as this} [_ payload :as action]]
  (go
    (let [[status :as res]   (<! (batch instance (action->es action)))]
      (if (= status :saved)
        (event/create [:saved payload])
        res))))
