(ns backend-adapters.stepfunctions.index
  (:require [aws-sdk :refer [StepFunctions]]
            [backend-adapters.stepfunctions.perform :refer [perform]]
            [backend-adapters.stepfunctions.specs :refer [specs]]
            [shared.models.event.index :as event]
            [shared.protocols.actionable :refer [Actionable]])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn create [{:keys [machine-names error]}]
  (specify {:instance (new StepFunctions)
            :specs specs
            :error error
            :machine-names machine-names}
    Actionable
    (-perform [{:keys [error] :as this} action]
      (if error
        (go (event/create [:failed error]))
        (perform this action)))))
