(ns backend-adapters.stepfunctions.converters.action
  (:require [shared.protocols.specced :as sp]))

(defmulti action->sf (fn [action _] (sp/resolve action)))

(defmethod action->sf [:trigger :repo-item] [[_ payload] machine-names]
  {:stateMachineArn (:repo-item machine-names)
   :input (.stringify js/JSON (clj->js payload))
   :name (str "repo-item-" (.now js/Date))})

(defmethod action->sf [:trigger :incomplete-bookmark] [[_ payload] machine-names]
  {:stateMachineArn (:incomplete-bookmark machine-names)
   :input (.stringify js/JSON (clj->js payload))
   :name (str "incomplete-bookmark-" (.now js/Date))})

(defmethod action->sf [:trigger :bookmark] [[_ payload] machine-names]
  {:stateMachineArn (:bookmark machine-names)
   :input (.stringify js/JSON (clj->js payload))
   :name (str "bookmark-" (.now js/Date))})

(defmethod action->sf [:trigger :course] [[_ payload] machine-names]
  {:stateMachineArn (:course machine-names)
   :input (.stringify js/JSON (clj->js payload))
   :name (str "course-" (.now js/Date))})

(defmethod action->sf [:trigger :courses] [[_ payload] machine-names]
  {:stateMachineArn (:courses machine-names)
   :input (.stringify js/JSON (clj->js payload))
   :name (str "courses-" (.now js/Date))})

(defmethod action->sf [:trigger :status] [[_ payload] machine-names]
  {:stateMachineArn (:status machine-names)
   :input (.stringify js/JSON (clj->js payload))
   :name (str "status-" (.now js/Date))})
