(ns backend-adapters.s3.specs
  (:require [cljs.spec.alpha :as spec]))

(defmulti action-spec (fn [[action-type _ :as action]] action-type))

(defmethod action-spec :save [_]
  (spec/tuple :action/types (spec/or :repo-items         (spec/coll-of :github/item-query)
                                     :resource           :resource/valid
                                     :status             :status/valid
                                     :course             :course/valid
                                     :missing-resource   :bookmark/missing-resource
                                     :raw-resource       :resource/raw
                                     :portrait           :portrait/valid
                                     :bookmarks          (spec/coll-of :bookmark/valid))))

(def specs {:action (spec/multi-spec action-spec :action-type)
            :query  (spec/or :raw-resource :bookmark/augmented
                             :bucket-item   :aws/bucket-item
                             :resource     :resource/query)})
