(ns backend-adapters.es.index
  (:require [backend-adapters.es.fetch :refer [fetch]]
            [backend-adapters.es.perform :refer [perform]]
            [backend-adapters.es.specs :refer [specs]]
            [cljs.nodejs :as node]
            [aws-sdk :as AWS]
            [elasticsearch :refer [Client]]
            [shared.models.event.index :as event]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.queryable :refer [Queryable]])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(.update (.-config AWS) (clj->js {:region "us-east-1"}))

(defn create [{:keys [search-url error]}]
  (specify! {:endpoint search-url
             :error    error
             :specs    specs
             :instance (Client. (clj->js {:hosts [(or search-url "")],
                                          :connectionClass (node/require "http-aws-es")}))}
    Queryable
    (-fetch [this query] (fetch this query))
    Actionable
    (-perform [{:keys [error] :as this} action]
      (if error
        (go (event/create [:failed error]))
        (perform this action)))))
