(ns backend-adapters.dynamodb.converters.query
  (:require [shared.protocols.specced :as sp]
            [clojure.walk :as walk]
            [shared.models.query.index :as query]
            [shared.protocols.loggable :as log]
            [cuerdas.core :as str]))

(defmulti query->ddb (fn [query _] (sp/resolve query)))

(defmethod query->ddb :course-by-id [{:keys [course-id revision] :as query} table-names]
  (query/create {:TableName (:course table-names)
                 :ExpressionAttributeNames {"#ci" "course-id"
                                            "#rev" "revision"}
                 :ExpressionAttributeValues {":civ" course-id
                                             ":revv" (int revision)}
                 :KeyConditionExpression (str "#ci = :civ AND #rev = :revv")}))

(defmethod query->ddb :course-by-slug [{:keys [course-slug curator] :as query} table-names]
  (query/create {:TableName (:course table-names)
                 :IndexName "curator-courses"
                 :ExpressionAttributeNames {"#gl" "goal"
                                            "#cur" "curator"}
                 :ExpressionAttributeValues {":glv" (str/human course-slug)
                                             ":curv" curator}
                 :KeyConditionExpression (str "#cur = :curv AND #gl = :glv")}))
