(ns backend-adapters.dynamodb.specs
  (:require [cljs.spec.alpha :as spec]))

(defmulti action-spec (fn [[action-type _ :as action]] action-type))

(defmethod action-spec :save [_]
  (spec/tuple :action/types (spec/or :course     :course/valid)))

(defmethod action-spec :update [_]
  (spec/tuple :action/types (spec/or :course :course/update)))

(def specs {:action (spec/multi-spec action-spec :action-type)
            :query  (spec/or :course-by-id    :course/query-by-id
                             :course-by-slug  :course/query-by-slug
                             :resource  :resource/query)})
