(defproject offcourse/backend-shared "0.5.39"
  :description     "This is an echo lambda function. It's mainly used for debugging purposes."
  :url             "https://gitlab.com/offcourse/services-shared"
  :license         {:name "MIT License"
                    :url "http://opensource.org/licenses/MIT"}
  :plugins         [[lein-cljsbuild "1.1.7"]
                    [lein-npm "0.6.2"]
                    [lein-pprint "1.1.2"]]
  :aliases          {"build"   ["do" ["clean"] ["npm" "install"] ["cljsbuild" "once"]]
                     "bump" ["change" "version" "leiningen.release/bump-version"]}
  :dependencies    [[org.clojure/clojure         "1.9.0-alpha17"]
                    [org.clojure/core.async      "0.3.443"]
                    [org.clojure/clojurescript   "1.9.854"]
                    [offcourse/specs             "0.1.15"]
                    [offcourse/shared            "0.11.13"]]
  :deploy-repositories [["clojars" {:url "https://clojars.org/repo"
                                   :username :env/CLOJARS_USER
                                   :password :env/CLOJARS_PASS
                                   :sign-releases false}]]
  :release-tasks [["change" "version" "leiningen.release/bump-version" "release"]
                  ["deploy" "clojars"]]
  :npm             {:dependencies {:atob "2.0.3",
                                   :aws-sdk "2.104.0",
                                   :btoa "1.1.2",
                                   :compromise "^10.5.2",
                                   :dynamodb-marshaler "2.0.0",
                                   :elasticsearch "^13.3.1",
                                   :fstream "1.0.10",
                                   :http-aws-es "3.1.0"
                                   :html-to-text "^3.3.0",
                                   :js-yaml "3.6.1",
                                   :jsonwebtoken "7.1.9",
                                   :node-zip "^1.1.1",
                                   :path "0.12.7",
                                   :request "2.75.0",
                                   :to-markdown "^3.0.4",
                                   :unzipper "0.7.2"}}
  :cljsbuild       {:builds [{:id "prod"
                              :source-paths ["src"]
                              :compiler {:target :nodejs
                                         :output-to "target/main.js"
                                         :install-deps true
                                         :optimizations :simple
                                         :pretty-print true
                                         :parallel-build true}}]})
