(ns backend-adapters.dynamodb.specs
  (:require [cljs.spec.alpha :as spec]))

(defmulti action-spec (fn [[action-type _ :as action]] action-type))

(defmethod action-spec :save [_]
  (spec/tuple :action/types (spec/or :course     :course/valid
                                     :profile    :profile/valid
                                     :identities (spec/coll-of :user/identity))))

(defmethod action-spec :update [_]
  (spec/tuple :action/types (spec/or :course :course/update)))

(def specs {:action (spec/multi-spec action-spec :action-type)
            :query  (spec/or :course    :course/query
                             :resource  :resource/query
                             :profile   :user/identity)})
