(ns backend-adapters.dynamodb.perform
  (:require [backend-adapters.dynamodb.converters.action :refer [action->ddb]]
            [backend-adapters.dynamodb.impl.save :refer [save]]
            [backend-adapters.dynamodb.impl.update :refer [update]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [cljs.core.async :refer [<!]]
            [shared.protocols.specced :as sp]
            [cljs.spec.alpha :as spec])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [_ action] (sp/resolve action)))

(defmethod perform [:update :course] [{:keys [instance table-names]} [_ payload :as action]]
  (go
    (let [[res-type :as res] (<! (update instance (action->ddb action table-names)))]
      (if (= res-type :saved)
        (event/create [:saved payload])
        res))))

(defmethod perform :default [{:keys [instance table-names]} [_ payload :as action]]
  (go
    (let [[res-type :as res] (<! (save instance (action->ddb action table-names)))]
      (if (= res-type :saved)
        (event/create [:saved payload])
        res))))

(defmethod perform :invalid-action [_ action]
  (go (event/create [:failed (error/create :dynamodb-unsupported-action action)])))
