(ns backend-adapters.s3.converters.query
  (:require [backend-shared.crypto :as crypto]
            [shared.protocols.specced :as sp]))

(defmulti query->s3 (fn [query _] (sp/resolve query)))

(defmethod query->s3 :bucket-item [{:keys [bucket-name item-key]} _]
  {:Bucket bucket-name
   :Key item-key})

(defmethod query->s3 :resource [{:keys [resource-url]} bucket-names]
  {:Bucket (:resource bucket-names)
   :Key (str (crypto/hasher resource-url) ".json")})

(defmethod query->s3 :raw-resource [{:keys [resource-url]} bucket-names]
  {:Bucket (:raw-resource bucket-names)
   :Key (str (crypto/hasher resource-url) ".json")})
