(ns backend-adapters.dynamodb.impl.save
  (:require [cljs.spec.alpha :as spec]
            [cljs.core.async :refer [<! chan into merge close! put!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]))

(defn- handle-response [channel error payload]
  (let [response (if error
                   (event/create [:failed (error/create :dynamodb-error error)])
                   (event/create [:saved payload]))]
    (put! channel response)
    (close! channel)))

(defn put [instance action]
  (let [c (chan)]
    (.put instance (clj->js action) #(handle-response c %1 %2))
    c))

(defn batch [instance actions]
  (let [c (chan)]
    (.batchWrite instance (clj->js actions) #(handle-response c %1 %2))
    c))

(defn save [instance payload]
  (if (:many? (meta payload))
    (batch instance payload)
    (put instance payload)))
