(ns backend-shared.service.check
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]
            [clojure.string :as str]))

(defmulti check (fn [{:keys [event user]} action]
                  (let [user-state (cond
                                     (:user-name user) :user
                                     (:auth-id user) :guest)]
                  (conj (sp/resolve action) user-state))))
