(ns backend-adapters.stepfunctions.specs
  (:require [cljs.spec.alpha :as spec]))

(defmulti action-spec (fn [[action-type _ :as action]] action-type))

(defmethod action-spec :trigger [_]
  (spec/tuple :action/types (spec/or :repo-item           :github/item-query
                                     :raw-user            :profile/raw
                                     :incomplete-bookmark :bookmark/augmented
                                     :bookmark            :bookmark/valid
                                     :courses             (spec/coll-of :course/valid)
                                     :course              :course/valid)))

(def specs {:action (spec/multi-spec action-spec :action-type)})

