(ns backend-adapters.http.index
  (:require [shared.protocols.queryable :refer [Queryable]]
            [backend-adapters.http.fetch :refer [fetch]]
            [backend-adapters.http.specs :refer [specs]]
            [request :as request]
            [shared.protocols.loggable :as log]))

(.defaults request
           (clj->js {:headers {:user-agent    "offcourse"}}))

(defn create [{:keys [error api-keys] :as this}]
  (specify! {:instance (.defaults request
                                  (clj->js {:headers {:user-agent    "offcourse"}}))
             :api-keys api-keys
             :specs specs}
    Queryable
    (-fetch [this query] (fetch this query))))
