(ns backend-adapters.s3.perform
  (:require [backend-adapters.s3.converters.action :refer [action->s3]]
            [backend-adapters.s3.impl.save :refer [save]]
            [cljs.core.async :refer [<!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [service action] (sp/resolve action)))

(defmethod perform :default [{:keys [instance bucket-names] :as this} [_ payload :as action]]
  (go
    (let [[res-type :as res] (<! (save instance (action->s3 action bucket-names)))]
      (if (= res-type :saved)
        (event/create [:saved payload])
        res))))

(defmethod perform :invalid-action [_ action]
  (go (event/create [:failed (error/create :s3-unsupported-action action)])))
