(ns backend-shared.converters.index
  (:require [backend-shared.converters.api :as api]
            [backend-shared.converters.github :as github]
            [backend-shared.converters.mercury :as mercury]
            [backend-shared.converters.raw-user :as raw-user]
            [backend-shared.converters.db-event :as db-event]
            [backend-shared.converters.zip :as zip]
            [cljs.nodejs :as node]
            [shared.models.course.index :as course]
            [shared.protocols.convertible :as cv]))

(defn find-checkpoint-index [checkpoints checkpoint-id]
  (->> checkpoints
       (map-indexed vector)
       (filter #(= (:checkpoint-id (second %)) checkpoint-id))
       first
       first))

(defn course->update [{:keys [source course resource] :as bookmark-data}]
  (let [{:keys [checkpoint-id]} source
        {:keys [checkpoints]} course
        {:keys [resource-url tags]} resource]
    (assoc source
           :resource-url resource-url
           :checkpoint-index (find-checkpoint-index checkpoints checkpoint-id)
           :tags (take 3 (into #{} tags)))))

(defn course->bookmarks [course]
  (-> course
      course/create
      cv/to-bookmarks))

(def raw->user-data    raw-user/->user-data)

(def repo->items       github/->items)
(def repo-item->course github/->course)

(def clj->compressed   zip/->compressed)
(def compressed->clj   zip/->clj)

(def db-event->event   db-event/->event)

(def response->api     api/->api)
(def mercury->resource mercury/->resource)
