(ns backend-adapters.s3.index
  (:require [backend-adapters.s3.fetch :refer [fetch]]
            [backend-adapters.s3.perform :refer [perform]]
            [backend-adapters.s3.specs :refer [specs]]
            [cljs.nodejs :as node]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.queryable :refer [Queryable]]))

(def AWS (node/require "aws-sdk"))

(defn create [{:keys [bucket-names]}]
  (specify! {:instance (new AWS.S3)
             :bucket-names bucket-names
             :specs specs}
    Queryable
    (-fetch
      ([this query] (fetch this query))
      ([this credentials query] (fetch this credentials query)))
    Actionable
    (-perform [this action] (perform this action))))
