(ns backend-adapters.es.impl.save
  (:require [cljs.core.async :refer [chan close! put!]]
            [cljs.nodejs :as node]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log]
            [shared.models.event.index :as event]
            [shared.models.error.index :as error]
            [clojure.string :as str]))

(defn handle-error [c error]
  (put! c (event/create [:failed (error/create :elasticsearch-error error)]))
  (close! c))

(defn handle-success [c res]
  (put! c (event/create [:saved (cv/to-clj res)]))
  (close! c))

(defn save [instance query]
  (let [c (chan)]
    (.then (.index instance (clj->js query))
           #(handle-success c %1)
           #(handle-error c %1))
    c))

(defn batch [instance query]
  (let [c (chan)]
    (.then (.bulk instance (clj->js query))
           #(handle-success c %1)
           #(handle-error c %1))
    c))
