(ns backend-adapters.dynamodb.specs
  (:require [cljs.spec.alpha :as spec]))

(defmulti action-spec (fn [[action-type _ :as action]] action-type))

(defmethod action-spec :save [_]
  (spec/tuple :offcourse/actions (spec/or :course     :offcourse/course
                                          :profile    :offcourse/profile
                                          :identities (spec/coll-of :offcourse/identity))))

(defmethod action-spec :update [_]
  (spec/tuple :offcourse/actions (spec/or :course :course/update)))

(def specs {:action (spec/multi-spec action-spec :action-type)
            :query  (spec/or :course :query/course)})
