(ns backend-adapters.dynamodb.index
  (:require [backend-adapters.dynamodb.fetch :refer [fetch]]
            [backend-adapters.dynamodb.perform :refer [perform]]
            [cljs.nodejs :as node]
            [backend-adapters.dynamodb.specs :refer [specs]]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.queryable :refer [Queryable]]))

(def AWS (node/require "aws-sdk"))

(defn create [{:keys [table-names]}]
  (specify {:instance (AWS.DynamoDB.DocumentClient.)
            :table-names  table-names
            :specs specs}
    Queryable
    (-fetch [table query] (fetch table query))
    Actionable
    (-perform [table action] (perform table action))))
