(ns backend-adapters.dynamodb.impl.update
  (:refer-clojure :exclude [update])
  (:require [cljs.spec.alpha :as spec]
            [cljs.core.async :refer [<! chan into merge close! put!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]))

(defn- handle-response [channel error payload]
  (let [response (if error
                   (event/create [:failed (error/create :dynamodb-error error)])
                   (event/create [:saved payload]))]
    (put! channel response)
    (close! channel)))

(defn update [instance action]
  (let [c (chan)]
    (.update instance (clj->js action) #(handle-response c %1 %2))
    c))
