(ns backend-adapters.es.perform
  (:require [cljs.core.async :refer [<! into merge]]
            [backend-adapters.es.impl.save :refer [save]]
            [shared.models.event.index :as event]
            [shared.protocols.specced :as sp]
            [shared.models.error.index :as error]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log])
  (:require-macros [cljs.core.async.macros :refer [go]]))

#_(defmulti action->es (fn [action] (sp/resolve action)))

(defn action->es [[_ payload]]
  (mapv (fn [{:keys [course-id] :as item}]
          {:index :offcourse
           :type :courses
           :id course-id
           :body item}) payload))

(defn failed? [[status _]] (= status :failed))

(defn perform [{:keys [endpoint instance] :as this} [_ payload :as action]]
  (go
    (let [chans   (merge (map #(save instance %) (action->es action)))
          res     (<! (into [] chans))
          errors  (filter failed? res)]
      (if (empty? errors)
        (event/create [:saved payload])
        (event/create [:failed (error/create :elasticsearch-error errors)])))))

