(ns backend-adapters.es.index
  (:require [backend-adapters.es.fetch :refer [fetch]]
            [backend-adapters.es.perform :refer [perform]]
            [cljs.nodejs :as node]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.queryable :refer [Queryable]]))

(def ES (aget (node/require "elasticsearch") "Client"))
(def AWS (node/require "aws-sdk"))
(.update (.-config AWS) (clj->js {:region "us-east-1"}))

(defn create [{:keys [index-names search-url]}]
  (specify! {:endpoint search-url
             :instance (ES. (clj->js {:hosts [ search-url ],
                                      :connectionClass (node/require "http-aws-es")}))}
    Queryable
    (-fetch [this query] (fetch this query))
    Actionable
    (-perform [this action] (perform this action))))
